/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.ErrorUml;
import net.sourceforge.plantuml.ErrorUmlType;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.StringLocated;
import net.sourceforge.plantuml.acearth.PSystemXearthFactory;
import net.sourceforge.plantuml.activitydiagram.ActivityDiagramFactory;
import net.sourceforge.plantuml.activitydiagram3.ActivityDiagramFactory3;
import net.sourceforge.plantuml.api.PSystemFactory;
import net.sourceforge.plantuml.bpm.BpmDiagramFactory;
import net.sourceforge.plantuml.classdiagram.ClassDiagramFactory;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.core.DiagramType;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.creole.PSystemCreoleFactory;
import net.sourceforge.plantuml.dedication.PSystemDedicationFactory;
import net.sourceforge.plantuml.definition.PSystemDefinitionFactory;
import net.sourceforge.plantuml.descdiagram.DescriptionDiagramFactory;
import net.sourceforge.plantuml.directdot.PSystemDotFactory;
import net.sourceforge.plantuml.ditaa.PSystemDitaaFactory;
import net.sourceforge.plantuml.donors.PSystemDonorsFactory;
import net.sourceforge.plantuml.donors.PSystemSkinparameterListFactory;
import net.sourceforge.plantuml.eggs.PSystemAppleTwoFactory;
import net.sourceforge.plantuml.eggs.PSystemCharlieFactory;
import net.sourceforge.plantuml.eggs.PSystemColorsFactory;
import net.sourceforge.plantuml.eggs.PSystemEggFactory;
import net.sourceforge.plantuml.eggs.PSystemRIPFactory;
import net.sourceforge.plantuml.eggs.PSystemWelcomeFactory;
import net.sourceforge.plantuml.error.PSystemError;
import net.sourceforge.plantuml.error.PSystemErrorUtils;
import net.sourceforge.plantuml.flowdiagram.FlowDiagramFactory;
import net.sourceforge.plantuml.font.PSystemListFontsFactory;
import net.sourceforge.plantuml.help.HelpFactory;
import net.sourceforge.plantuml.jcckit.PSystemJcckitFactory;
import net.sourceforge.plantuml.math.PSystemLatexFactory;
import net.sourceforge.plantuml.math.PSystemMathFactory;
import net.sourceforge.plantuml.mindmap.MindMapDiagramFactory;
import net.sourceforge.plantuml.nwdiag.NwDiagramFactory;
import net.sourceforge.plantuml.openiconic.PSystemListOpenIconicFactory;
import net.sourceforge.plantuml.openiconic.PSystemOpenIconicFactory;
import net.sourceforge.plantuml.oregon.PSystemOregonFactory;
import net.sourceforge.plantuml.project.GanttDiagramFactory;
import net.sourceforge.plantuml.salt.PSystemSaltFactory;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagramFactory;
import net.sourceforge.plantuml.sprite.ListSpriteDiagramFactory;
import net.sourceforge.plantuml.sprite.PSystemListInternalSpritesFactory;
import net.sourceforge.plantuml.sprite.StdlibDiagramFactory;
import net.sourceforge.plantuml.statediagram.StateDiagramFactory;
import net.sourceforge.plantuml.stats.StatsUtilsIncrement;
import net.sourceforge.plantuml.sudoku.PSystemSudokuFactory;
import net.sourceforge.plantuml.timingdiagram.TimingDiagramFactory;
import net.sourceforge.plantuml.version.License;
import net.sourceforge.plantuml.version.PSystemLicenseFactory;
import net.sourceforge.plantuml.version.PSystemVersionFactory;
import net.sourceforge.plantuml.wbs.WBSDiagramFactory;
import net.sourceforge.plantuml.wire.WireDiagramFactory;

public class PSystemBuilder {
    public static final long startTime = System.currentTimeMillis();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Diagram createPSystem(ISkinSimple skinParam, List<StringLocated> strings2) {
        long now = System.currentTimeMillis();
        Object result = null;
        try {
            DiagramType type = DiagramType.getTypeFromArobaseStart(strings2.get(0).getString());
            UmlSource umlSource = new UmlSource(strings2, type == DiagramType.UML);
            for (StringLocated s : strings2) {
                if (s.getPreprocessorError() == null) continue;
                Log.error("Preprocessor Error: " + s.getPreprocessorError());
                ErrorUml err = new ErrorUml(ErrorUmlType.SYNTAX_ERROR, s.getPreprocessorError(), s.getLocation());
                PSystemError pSystemError = PSystemErrorUtils.buildV2(umlSource, err, Collections.<String>emptyList(), strings2);
                return pSystemError;
            }
            DiagramType diagramType = umlSource.getDiagramType();
            ArrayList<PSystemError> errors = new ArrayList<PSystemError>();
            List<PSystemFactory> factories = PSystemBuilder.getAllFactories(skinParam);
            for (PSystemFactory systemFactory : factories) {
                if (diagramType != systemFactory.getDiagramType()) continue;
                Diagram sys = systemFactory.createSystem(umlSource);
                if (this.isOk(sys)) {
                    result = sys;
                    Diagram diagram = sys;
                    return diagram;
                }
                errors.add((PSystemError)sys);
            }
            PSystemError err = PSystemErrorUtils.merge(errors);
            result = err;
            PSystemError pSystemError = err;
            return pSystemError;
        }
        finally {
            if (result != null && OptionFlags.getInstance().isEnableStats()) {
                StatsUtilsIncrement.onceMoreParse(System.currentTimeMillis() - now, result.getClass());
            }
            Log.info("Compilation duration " + (System.currentTimeMillis() - now));
            RegexConcat.printCacheInfo();
        }
    }

    private static List<PSystemFactory> getAllFactories(ISkinSimple skinParam) {
        ArrayList<PSystemFactory> factories = new ArrayList<PSystemFactory>();
        factories.add(new PSystemWelcomeFactory());
        factories.add(new PSystemColorsFactory());
        factories.add(new SequenceDiagramFactory(skinParam));
        factories.add(new ClassDiagramFactory(skinParam));
        factories.add(new ActivityDiagramFactory(skinParam));
        factories.add(new DescriptionDiagramFactory(skinParam));
        factories.add(new StateDiagramFactory(skinParam));
        factories.add(new ActivityDiagramFactory3(skinParam));
        factories.add(new BpmDiagramFactory(DiagramType.BPM));
        factories.add(new PSystemLicenseFactory());
        factories.add(new PSystemVersionFactory());
        factories.add(new PSystemDonorsFactory());
        factories.add(new PSystemSkinparameterListFactory());
        factories.add(new PSystemListFontsFactory());
        factories.add(new PSystemOpenIconicFactory());
        factories.add(new PSystemListOpenIconicFactory());
        factories.add(new PSystemListInternalSpritesFactory());
        factories.add(new PSystemSaltFactory(DiagramType.SALT));
        factories.add(new PSystemSaltFactory(DiagramType.UML));
        factories.add(new PSystemDotFactory(DiagramType.DOT));
        factories.add(new PSystemDotFactory(DiagramType.UML));
        factories.add(new NwDiagramFactory());
        factories.add(new MindMapDiagramFactory());
        factories.add(new WBSDiagramFactory());
        factories.add(new PSystemDitaaFactory(DiagramType.DITAA));
        factories.add(new PSystemDitaaFactory(DiagramType.UML));
        if (License.getCurrent() == License.GPL || License.getCurrent() == License.GPLV2) {
            factories.add(new PSystemJcckitFactory(DiagramType.JCCKIT));
            factories.add(new PSystemJcckitFactory(DiagramType.UML));
            factories.add(new PSystemSudokuFactory());
        }
        factories.add(new PSystemDefinitionFactory());
        factories.add(new ListSpriteDiagramFactory(skinParam));
        factories.add(new StdlibDiagramFactory(skinParam));
        factories.add(new PSystemMathFactory(DiagramType.MATH));
        factories.add(new PSystemLatexFactory(DiagramType.LATEX));
        factories.add(new PSystemCreoleFactory());
        factories.add(new PSystemEggFactory());
        factories.add(new PSystemAppleTwoFactory());
        factories.add(new PSystemRIPFactory());
        factories.add(new PSystemOregonFactory());
        factories.add(new PSystemCharlieFactory());
        if (License.getCurrent() == License.GPL || License.getCurrent() == License.GPLV2) {
            factories.add(new PSystemXearthFactory());
        }
        factories.add(new GanttDiagramFactory(DiagramType.GANTT));
        factories.add(new GanttDiagramFactory(DiagramType.UML));
        factories.add(new FlowDiagramFactory());
        factories.add(new PSystemDedicationFactory());
        factories.add(new TimingDiagramFactory());
        factories.add(new HelpFactory());
        factories.add(new WireDiagramFactory());
        return factories;
    }

    private boolean isOk(Diagram ps) {
        return ps != null && !(ps instanceof PSystemError);
    }
}

