/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParam;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractConnection;
import net.sourceforge.plantuml.activitydiagram3.ftile.Arrows;
import net.sourceforge.plantuml.activitydiagram3.ftile.Connection;
import net.sourceforge.plantuml.activitydiagram3.ftile.ConnectionTranslatable;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileAssemblySimple;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileKilled;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileUtils;
import net.sourceforge.plantuml.activitydiagram3.ftile.Snake;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.AbstractParallelFtilesBuilder;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileThinSplit;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.Rainbow;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class ParallelBuilderSplit
extends AbstractParallelFtilesBuilder {
    public ParallelBuilderSplit(ISkinParam skinParam, StringBounder stringBounder, List<Ftile> all) {
        super(skinParam, stringBounder, all);
    }

    @Override
    public StyleSignature getDefaultStyleDefinition() {
        return StyleSignature.of(SName.root, SName.element, SName.activityDiagram, SName.arrow);
    }

    @Override
    protected Ftile doStep1(Ftile inner) {
        Rainbow thinColor;
        Ftile result = inner;
        ArrayList<Connection> conns = new ArrayList<Connection>();
        if (SkinParam.USE_STYLES()) {
            Style style = this.getDefaultStyleDefinition().getMergedStyle(this.skinParam().getCurrentStyleBuilder());
            thinColor = Rainbow.build(style, this.skinParam().getIHtmlColorSet());
        } else {
            thinColor = result.getInLinkRendering().getRainbow(Rainbow.build(this.skinParam()));
        }
        FtileThinSplit thin = new FtileThinSplit(this.skinParam(), this.getThin1Color(thinColor), ((Ftile)this.list99.get(0)).getSwimlaneIn());
        double x = 0.0;
        double first = 0.0;
        double last = 0.0;
        for (Ftile tmp : this.list99) {
            Rainbow rainbow;
            FtileGeometry dim = tmp.calculateDimension(this.getStringBounder());
            if (first == 0.0) {
                first = x + dim.getLeft();
            }
            last = x + dim.getLeft();
            LinkRendering inLinkRendering = tmp.getInLinkRendering();
            if (SkinParam.USE_STYLES()) {
                Style style = this.getDefaultStyleDefinition().getMergedStyle(this.skinParam().getCurrentStyleBuilder());
                rainbow = inLinkRendering.getRainbow(Rainbow.build(style, this.skinParam().getIHtmlColorSet()));
            } else {
                rainbow = inLinkRendering.getRainbow(Rainbow.build(this.skinParam()));
            }
            conns.add(new ConnectionIn(thin, tmp, x, rainbow));
            x += dim.getWidth();
        }
        FtileGeometry geom = (result = FtileUtils.addConnection(result, conns)).calculateDimension(this.getStringBounder());
        if (last < geom.getLeft()) {
            last = geom.getLeft();
        }
        if (first > geom.getLeft()) {
            first = geom.getLeft();
        }
        thin.setGeom(first, last, result.calculateDimension(this.getStringBounder()).getWidth());
        return new FtileAssemblySimple(thin, result);
    }

    private HColor getThin1Color(Rainbow thinColor) {
        for (Ftile tmp : this.list99) {
            Rainbow rainbow;
            LinkRendering inLinkRendering = tmp.getInLinkRendering();
            if (SkinParam.USE_STYLES()) {
                Style style = this.getDefaultStyleDefinition().getMergedStyle(this.skinParam().getCurrentStyleBuilder());
                rainbow = inLinkRendering.getRainbow(Rainbow.build(style, this.skinParam().getIHtmlColorSet()));
            } else {
                rainbow = inLinkRendering.getRainbow(Rainbow.build(this.skinParam()));
            }
            if (rainbow.isInvisible()) continue;
            return thinColor.getColor();
        }
        return null;
    }

    private boolean hasOut() {
        for (Ftile tmp : this.list99) {
            boolean hasOutTmp = tmp.calculateDimension(this.getStringBounder()).hasPointOut();
            if (!hasOutTmp) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Ftile doStep2(Ftile inner, Ftile result) {
        Rainbow thinColor;
        FtileGeometry geom = result.calculateDimension(this.getStringBounder());
        if (!this.hasOut()) {
            return new FtileKilled(result);
        }
        LinkRendering inLinkRendering = result.getInLinkRendering();
        if (SkinParam.USE_STYLES()) {
            Style style = this.getDefaultStyleDefinition().getMergedStyle(this.skinParam().getCurrentStyleBuilder());
            thinColor = inLinkRendering.getRainbow(Rainbow.build(style, this.skinParam().getIHtmlColorSet()));
        } else {
            thinColor = inLinkRendering.getRainbow(Rainbow.build(this.skinParam()));
        }
        FtileThinSplit out = new FtileThinSplit(this.skinParam(), thinColor.getColor(), this.swimlaneOutForStep2());
        result = new FtileAssemblySimple(result, out);
        ArrayList<Connection> conns = new ArrayList<Connection>();
        double x = 0.0;
        double first = 0.0;
        double last = 0.0;
        for (Ftile tmp : this.list99) {
            Rainbow rainbow;
            UTranslate translate0 = UTranslate.dy(1.5);
            FtileGeometry dim = tmp.calculateDimension(this.getStringBounder());
            if (dim.hasPointOut()) {
                if (first == 0.0) {
                    first = x + dim.getLeft();
                }
                last = x + dim.getLeft();
            }
            LinkRendering outLinkRendering = tmp.getOutLinkRendering();
            if (SkinParam.USE_STYLES()) {
                Style style = this.getDefaultStyleDefinition().getMergedStyle(this.skinParam().getCurrentStyleBuilder());
                rainbow = outLinkRendering.getRainbow(Rainbow.build(style, this.skinParam().getIHtmlColorSet()));
            } else {
                rainbow = outLinkRendering.getRainbow(Rainbow.build(this.skinParam()));
            }
            conns.add(new ConnectionOut(translate0, tmp, out, x, rainbow, this.getHeightOfMiddle(inner)));
            x += dim.getWidth();
        }
        if (last < geom.getLeft()) {
            last = geom.getLeft();
        }
        if (first > geom.getLeft()) {
            first = geom.getLeft();
        }
        out.setGeom(first, last, geom.getWidth());
        result = FtileUtils.addConnection(result, conns);
        return result;
    }

    class ConnectionOut
    extends AbstractConnection
    implements ConnectionTranslatable {
        private final double x;
        private final Rainbow arrowColor;
        private final double height;
        private final Display label;
        private final UTranslate translate0;

        public ConnectionOut(UTranslate translate0, Ftile ftile1, Ftile ftile2, double x, Rainbow arrowColor, double height) {
            super(ftile1, ftile2);
            this.translate0 = translate0;
            this.label = ftile1.getOutLinkRendering().getDisplay();
            this.x = x;
            this.arrowColor = arrowColor;
            this.height = height;
        }

        @Override
        public void drawU(UGraphic ug) {
            ug = ug.apply(UTranslate.dx(this.x));
            FtileGeometry geo = this.getFtile1().calculateDimension(ParallelBuilderSplit.this.getStringBounder());
            if (!geo.hasPointOut()) {
                return;
            }
            Snake snake = new Snake(this.arrowHorizontalAlignment(), this.arrowColor, Arrows.asToDown());
            if (!Display.isNull(this.label)) {
                snake.setLabel(ParallelBuilderSplit.this.getTextBlock(this.label));
            }
            Point2D p1 = this.translate0.getTranslated(new Point2D.Double(geo.getLeft(), geo.getOutY()));
            Point2D p2 = this.translate0.getTranslated(new Point2D.Double(geo.getLeft(), this.height));
            snake.addPoint(p1);
            snake.addPoint(p2);
            ug.draw(snake);
        }

        @Override
        public void drawTranslate(UGraphic ug, UTranslate translate1, UTranslate translate2) {
            ug = ug.apply(UTranslate.dx(this.x));
            FtileGeometry geo = this.getFtile1().calculateDimension(ParallelBuilderSplit.this.getStringBounder());
            if (!geo.hasPointOut()) {
                return;
            }
            Point2D p1 = this.translate0.getTranslated(new Point2D.Double(geo.getLeft(), geo.getOutY()));
            Point2D p2 = this.translate0.getTranslated(new Point2D.Double(geo.getLeft(), this.height));
            Snake snake = new Snake(this.arrowHorizontalAlignment(), this.arrowColor, Arrows.asToDown());
            if (!Display.isNull(this.label)) {
                snake.setLabel(ParallelBuilderSplit.this.getTextBlock(this.label));
            }
            Point2D mp1a = translate1.getTranslated(p1);
            Point2D mp2b = translate2.getTranslated(p2);
            double middle = mp2b.getY() - 14.0;
            snake.addPoint(mp1a);
            snake.addPoint(mp1a.getX(), middle);
            snake.addPoint(mp2b.getX(), middle);
            snake.addPoint(mp2b);
            ug.draw(snake);
        }
    }

    class ConnectionIn
    extends AbstractConnection
    implements ConnectionTranslatable {
        private final double x;
        private final Rainbow arrowColor;
        private final Display label;

        public ConnectionIn(Ftile ftile1, Ftile ftile2, double x, Rainbow arrowColor) {
            super(ftile1, ftile2);
            this.label = ftile2.getInLinkRendering().getDisplay();
            this.x = x;
            this.arrowColor = arrowColor;
        }

        @Override
        public void drawU(UGraphic ug) {
            ug = ug.apply(UTranslate.dx(this.x));
            FtileGeometry geo = this.getFtile2().calculateDimension(ParallelBuilderSplit.this.getStringBounder());
            Snake snake = new Snake(this.arrowHorizontalAlignment(), this.arrowColor, Arrows.asToDown());
            if (!Display.isNull(this.label)) {
                snake.setLabel(ParallelBuilderSplit.this.getTextBlock(this.label));
            }
            snake.addPoint(geo.getLeft(), 0.0);
            snake.addPoint(geo.getLeft(), geo.getInY());
            ug.draw(snake);
        }

        @Override
        public void drawTranslate(UGraphic ug, UTranslate translate1, UTranslate translate2) {
            ug = ug.apply(UTranslate.dx(this.x));
            FtileGeometry geo = this.getFtile2().calculateDimension(ParallelBuilderSplit.this.getStringBounder());
            Point2D.Double p1 = new Point2D.Double(geo.getLeft(), 0.0);
            Point2D.Double p2 = new Point2D.Double(geo.getLeft(), geo.getInY());
            Snake snake = new Snake(this.arrowHorizontalAlignment(), this.arrowColor, Arrows.asToDown());
            if (!Display.isNull(this.label)) {
                snake.setLabel(ParallelBuilderSplit.this.getTextBlock(this.label));
            }
            Point2D mp1a = translate1.getTranslated(p1);
            Point2D mp2b = translate2.getTranslated(p2);
            double middle = mp1a.getY() + 4.0;
            snake.addPoint(mp1a);
            snake.addPoint(mp1a.getX(), middle);
            snake.addPoint(mp2b.getX(), middle);
            snake.addPoint(mp2b);
            ug.draw(snake);
        }
    }
}

