/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.code;

import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import net.sourceforge.plantuml.code.ByteArray;
import net.sourceforge.plantuml.code.Compression;
import net.sourceforge.plantuml.code.CompressionZopfliZlib;
import net.sourceforge.plantuml.code.NoPlantumlCompressionException;

public class CompressionZlib
implements Compression {
    private static boolean USE_ZOPFLI = false;
    private static final int COMPRESSION_LEVEL = 9;

    @Override
    public byte[] compress(byte[] in) {
        if (USE_ZOPFLI) {
            return new CompressionZopfliZlib().compress(in);
        }
        if (in.length == 0) {
            return null;
        }
        int len = in.length * 2;
        if (len < 1000) {
            len = 1000;
        }
        byte[] result = null;
        result = this.tryCompress(in, len);
        return result;
    }

    private byte[] tryCompress(byte[] in, int len) {
        Deflater compresser = new Deflater(9, true);
        compresser.setInput(in);
        compresser.finish();
        byte[] output = new byte[len];
        int compressedDataLength = compresser.deflate(output);
        if (!compresser.finished()) {
            return null;
        }
        byte[] result = this.copyArray(output, compressedDataLength);
        return result;
    }

    @Override
    public ByteArray decompress(byte[] in) throws NoPlantumlCompressionException {
        try {
            byte[] in2 = new byte[in.length + 256];
            System.arraycopy(in, 0, in2, 0, in.length);
            int len = 100000;
            byte[] result = null;
            result = this.tryDecompress(in2, len);
            if (result == null) {
                throw new NoPlantumlCompressionException("Too big?");
            }
            return ByteArray.from(result);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new NoPlantumlCompressionException(e);
        }
    }

    private byte[] tryDecompress(byte[] in, int len) throws IOException {
        if (len > 200000) {
            throw new IOException("OutOfMemory");
        }
        byte[] tmp = new byte[len];
        Inflater decompresser = new Inflater(true);
        decompresser.setInput(in);
        try {
            int resultLength = decompresser.inflate(tmp);
            if (!decompresser.finished()) {
                return null;
            }
            decompresser.end();
            byte[] result = this.copyArray(tmp, resultLength);
            return result;
        }
        catch (DataFormatException e) {
            throw new IOException(e.toString());
        }
    }

    private byte[] copyArray(byte[] data, int len) {
        byte[] result = new byte[len];
        System.arraycopy(data, 0, result, 0, len);
        return result;
    }
}

