/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParam;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.Election;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Member;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.InnerStrategy;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockLineBefore;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.TextBlockWidth;
import net.sourceforge.plantuml.graphic.TextBlockWithUrl;
import net.sourceforge.plantuml.skin.VisibilityModifier;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.svek.Ports;
import net.sourceforge.plantuml.svek.WithPorts;
import net.sourceforge.plantuml.ugraphic.AbstractPlacementStrategy;
import net.sourceforge.plantuml.ugraphic.PlacementStrategyVisibility;
import net.sourceforge.plantuml.ugraphic.PlacementStrategyY1Y2Center;
import net.sourceforge.plantuml.ugraphic.PlacementStrategyY1Y2Left;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULayoutGroup;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.utils.CharHidder;

public class MethodsOrFieldsArea
extends AbstractTextBlock
implements TextBlockWidth,
TextBlock,
WithPorts {
    private final FontParam fontParam;
    private final ISkinParam skinParam;
    private final Rose rose = new Rose();
    private final List<Member> members = new ArrayList<Member>();
    private final HorizontalAlignment align;
    private final Stereotype stereotype;
    private final ILeaf leaf;

    public TextBlock asBlockMemberImpl() {
        return new TextBlockLineBefore(TextBlockUtils.withMargin(this, 6.0, 4.0));
    }

    public MethodsOrFieldsArea(List<Member> members, FontParam fontParam, ISkinParam skinParam, Stereotype stereotype, ILeaf leaf) {
        this(members, fontParam, skinParam, HorizontalAlignment.LEFT, stereotype, leaf);
    }

    public MethodsOrFieldsArea(List<Member> members, FontParam fontParam, ISkinParam skinParam, HorizontalAlignment align, Stereotype stereotype, ILeaf leaf) {
        this.leaf = leaf;
        this.stereotype = stereotype;
        this.align = align;
        this.skinParam = skinParam;
        this.fontParam = fontParam;
        this.members.addAll(members);
    }

    private boolean hasSmallIcon() {
        if (this.skinParam.classAttributeIconSize() == 0) {
            return false;
        }
        for (Member m : this.members) {
            if (m.getVisibilityModifier() == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        double smallIcon = 0.0;
        if (this.hasSmallIcon()) {
            smallIcon = this.skinParam.getCircledCharacterRadius() + 3;
        }
        double x = 0.0;
        double y = 0.0;
        for (Member m : this.members) {
            TextBlock bloc = this.createTextBlock(m);
            Dimension2D dim = bloc.calculateDimension(stringBounder);
            x = Math.max(dim.getWidth(), x);
            y += dim.getHeight();
        }
        return new Dimension2DDouble(x += smallIcon, y);
    }

    @Override
    public Ports getPorts(StringBounder stringBounder) {
        Ports result = new Ports();
        double y = 0.0;
        Election election = new Election();
        for (Member m : this.members) {
            election.addCandidate(m.getDisplay(false), m);
        }
        Map<Member, String> memberWithPort = election.getAllElected(this.leaf.getPortShortNames());
        for (Member m : this.members) {
            TextBlock bloc = this.createTextBlock(m);
            Dimension2D dim = bloc.calculateDimension(stringBounder);
            String port = memberWithPort.get(m);
            if (port != null) {
                result.add(port, y, dim.getHeight());
            }
            y += dim.getHeight();
        }
        return result;
    }

    private TextBlock createTextBlock(Member m) {
        FontConfiguration config;
        boolean withVisibilityChar = this.skinParam.classAttributeIconSize() == 0;
        String s = m.getDisplay(withVisibilityChar);
        if (withVisibilityChar && s.startsWith("#")) {
            s = CharHidder.addTileAtBegin(s);
        }
        if (SkinParam.USE_STYLES()) {
            Style style = StyleSignature.of(SName.root, SName.element, SName.componentDiagram, SName.component).getMergedStyle(this.skinParam.getCurrentStyleBuilder());
            config = new FontConfiguration(style, this.skinParam, this.stereotype, this.fontParam);
        } else {
            config = new FontConfiguration(this.skinParam, this.fontParam, this.stereotype);
        }
        if (m.isAbstract()) {
            config = config.italic();
        }
        if (m.isStatic()) {
            config = config.underline();
        }
        TextBlock bloc = Display.getWithNewlines(s).create8(config, this.align, this.skinParam, CreoleMode.SIMPLE_LINE, this.skinParam.wrapWidth());
        bloc = TextBlockUtils.fullInnerPosition(bloc, m.getDisplay(false));
        return new TextBlockTracer(m, bloc);
    }

    private TextBlock getUBlock(VisibilityModifier modifier, Url url) {
        if (modifier == null) {
            return new AbstractTextBlock(){

                @Override
                public void drawU(UGraphic ug) {
                }

                @Override
                public Rectangle2D getInnerPosition(String member, StringBounder stringBounder, InnerStrategy strategy) {
                    return null;
                }

                @Override
                public Dimension2D calculateDimension(StringBounder stringBounder) {
                    return new Dimension2DDouble(1.0, 1.0);
                }
            };
        }
        HColor back = modifier.getBackground() == null ? null : this.rose.getHtmlColor(this.skinParam, modifier.getBackground());
        HColor fore = this.rose.getHtmlColor(this.skinParam, modifier.getForeground());
        TextBlock uBlock = modifier.getUBlock(this.skinParam.classAttributeIconSize(), fore, back, url != null);
        return TextBlockWithUrl.withUrl(uBlock, url);
    }

    @Override
    public TextBlock asTextBlock(double widthToUse) {
        return this;
    }

    public boolean contains(String member) {
        for (Member att : this.members) {
            if (!att.getDisplay(false).startsWith(member)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Rectangle2D getInnerPosition(String member, StringBounder stringBounder, InnerStrategy strategy) {
        ULayoutGroup group = this.getLayout(stringBounder);
        Dimension2D dim = this.calculateDimension(stringBounder);
        return group.getInnerPosition(member, dim.getWidth(), dim.getHeight(), stringBounder);
    }

    private ULayoutGroup getLayout(StringBounder stringBounder) {
        ULayoutGroup group;
        if (this.hasSmallIcon()) {
            group = new ULayoutGroup(new PlacementStrategyVisibility(stringBounder, this.skinParam.getCircledCharacterRadius() + 3));
            for (Member att : this.members) {
                TextBlock bloc = this.createTextBlock(att);
                VisibilityModifier modifier = att.getVisibilityModifier();
                group.add(this.getUBlock(modifier, att.getUrl()));
                group.add(bloc);
            }
        } else {
            AbstractPlacementStrategy placementStrategy = this.align == HorizontalAlignment.LEFT ? new PlacementStrategyY1Y2Left(stringBounder) : (this.align == HorizontalAlignment.CENTER ? new PlacementStrategyY1Y2Center(stringBounder) : new PlacementStrategyY1Y2Left(stringBounder));
            group = new ULayoutGroup(placementStrategy);
            for (Member att : this.members) {
                TextBlock bloc = this.createTextBlock(att);
                group.add(bloc);
            }
        }
        return group;
    }

    @Override
    public void drawU(UGraphic ug) {
        ULayoutGroup group = this.getLayout(ug.getStringBounder());
        Dimension2D dim = this.calculateDimension(ug.getStringBounder());
        group.drawU(ug, dim.getWidth(), dim.getHeight());
    }

    static class TextBlockTracer
    extends AbstractTextBlock
    implements TextBlock {
        private final TextBlock bloc;
        private final Url url;

        public TextBlockTracer(Member m, TextBlock bloc) {
            this.bloc = bloc;
            this.url = m.getUrl();
        }

        @Override
        public void drawU(UGraphic ug) {
            if (this.url != null) {
                ug.startUrl(this.url);
            }
            this.bloc.drawU(ug);
            if (this.url != null) {
                ug.closeAction();
            }
        }

        @Override
        public Dimension2D calculateDimension(StringBounder stringBounder) {
            Dimension2D dim = this.bloc.calculateDimension(stringBounder);
            return dim;
        }

        @Override
        public Rectangle2D getInnerPosition(String member, StringBounder stringBounder, InnerStrategy strategy) {
            return this.bloc.getInnerPosition(member, stringBounder, strategy);
        }
    }
}

