/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.nwdiag;

import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.nwdiag.LinkedElement;
import net.sourceforge.plantuml.nwdiag.Network;
import net.sourceforge.plantuml.skin.ActorStyle;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class DiagElement {
    private USymbol shape = USymbol.RECTANGLE;
    private final String name;
    private String description;
    private final Network mainNetwork;

    public String toString() {
        return this.name;
    }

    public DiagElement(String name, Network network) {
        this.description = name;
        this.mainNetwork = network;
        this.name = name;
    }

    private TextBlock toTextBlock(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return TextBlockUtils.empty(0.0, 0.0);
        }
        s = s.replace(", ", "\\n");
        return Display.getWithNewlines(s).create(this.getFontConfiguration(), HorizontalAlignment.LEFT, new SpriteContainerEmpty());
    }

    private FontConfiguration getFontConfiguration() {
        UFont font = UFont.serif(11);
        return new FontConfiguration(font, HColorUtils.BLACK, HColorUtils.BLACK, false);
    }

    public LinkedElement asTextBlock(String adress1, String adress2) {
        TextBlock ad1 = this.toTextBlock(adress1);
        TextBlock ad2 = this.toTextBlock(adress2);
        SymbolContext symbolContext = new SymbolContext(ColorParam.activityBackground.getDefaultValue(), ColorParam.activityBorder.getDefaultValue()).withShadow(3.0);
        TextBlock desc = this.toTextBlock(this.description);
        TextBlock box = this.shape.asSmall(TextBlockUtils.empty(0.0, 0.0), desc, TextBlockUtils.empty(0.0, 0.0), symbolContext, HorizontalAlignment.CENTER);
        return new LinkedElement(ad1, box, ad2, this.mainNetwork, this);
    }

    public String getDescription() {
        return this.description;
    }

    public final Network getMainNetwork() {
        return this.mainNetwork;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public final void setShape(String shapeName) {
        USymbol shapeFromString = USymbol.getFromString(shapeName, ActorStyle.STICKMAN);
        if (shapeFromString != null) {
            this.shape = shapeFromString;
        }
    }
}

