/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.preproc;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.AFile;
import net.sourceforge.plantuml.AFileRegular;
import net.sourceforge.plantuml.AFileZipEntry;
import net.sourceforge.plantuml.AParentFolder;
import net.sourceforge.plantuml.FileSystem;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.preproc.FileWithSuffix;

public class ImportedFiles {
    private final List<File> imported;
    private final AParentFolder currentDir;

    private ImportedFiles(List<File> imported, AParentFolder currentDir) {
        this.imported = imported;
        this.currentDir = currentDir;
    }

    public ImportedFiles withCurrentDir(AParentFolder newCurrentDir) {
        if (newCurrentDir == null) {
            return this;
        }
        return new ImportedFiles(this.imported, newCurrentDir);
    }

    public static ImportedFiles createImportedFiles(AParentFolder newCurrentDir) {
        return new ImportedFiles(new ArrayList<File>(), newCurrentDir);
    }

    public String toString() {
        return "ImportedFiles=" + this.imported + " currentDir=" + this.currentDir;
    }

    public AFile getAFile(String nameOrPath) throws IOException {
        AParentFolder dir = this.currentDir;
        if (dir == null || this.isAbsolute(nameOrPath)) {
            return new AFileRegular(new File(nameOrPath).getCanonicalFile());
        }
        AFile filecurrent = dir.getAFile(nameOrPath);
        Log.info("ImportedFiles::getAFile filecurrent = " + filecurrent);
        if (filecurrent != null && filecurrent.isOk()) {
            return filecurrent;
        }
        for (File d : this.getPath()) {
            AFileZipEntry zipEntry;
            if (d.isDirectory()) {
                File file = new File(d, nameOrPath);
                if (!file.exists()) continue;
                return new AFileRegular(file.getCanonicalFile());
            }
            if (!d.isFile() || !(zipEntry = new AFileZipEntry(d, nameOrPath)).isOk()) continue;
            return zipEntry;
        }
        return filecurrent;
    }

    public List<File> getPath() {
        ArrayList<File> result = new ArrayList<File>(this.imported);
        result.addAll(this.includePath());
        result.addAll(FileSystem.getPath("java.class.path", true));
        return result;
    }

    private List<File> includePath() {
        return FileSystem.getPath("plantuml.include.path", true);
    }

    private boolean isAbsolute(String nameOrPath) {
        File f = new File(nameOrPath);
        return f.isAbsolute();
    }

    public void add(File file) {
        this.imported.add(file);
    }

    public AParentFolder getCurrentDir() {
        return this.currentDir;
    }

    public FileWithSuffix getFile(String filename, String suffix) throws IOException {
        String entry;
        AFile file;
        int idx = filename.indexOf(126);
        if (idx == -1) {
            file = this.getAFile(filename);
            entry = null;
        } else {
            file = this.getAFile(filename.substring(0, idx));
            entry = filename.substring(idx + 1);
        }
        if (!this.isAllowed(file)) {
            return FileWithSuffix.none();
        }
        return new FileWithSuffix(filename, suffix, file, entry);
    }

    private boolean isAllowed(AFile file) throws IOException {
        if (OptionFlags.ALLOW_INCLUDE) {
            return true;
        }
        if (file != null) {
            File folder = file.getSystemFolder();
            if (this.includePath().contains(folder)) {
                return true;
            }
        }
        return false;
    }
}

