/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.command;

import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.project.GanttConstraint;
import net.sourceforge.plantuml.project.GanttDiagram;
import net.sourceforge.plantuml.project.core.Task;
import net.sourceforge.plantuml.project.core.TaskAttribute;
import net.sourceforge.plantuml.project.core.TaskInstant;

public class CommandGanttArrow
extends SingleLineCommand2<GanttDiagram> {
    public CommandGanttArrow() {
        super(CommandGanttArrow.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandGanttArrow.class.getName(), RegexLeaf.start(), new RegexLeaf("CODE1", "([\\p{L}0-9_.]+)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("ARROW", "(-+)"), new RegexLeaf("\\>"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("CODE2", "([\\p{L}0-9_.]+)"), RegexLeaf.spaceZeroOrMore(), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(GanttDiagram diagram, LineLocation location, RegexResult arg) {
        String code1 = arg.get("CODE1", 0);
        String code2 = arg.get("CODE2", 0);
        Task task1 = diagram.getExistingTask(code1);
        if (task1 == null) {
            return CommandExecutionResult.error("No such task " + code1);
        }
        Task task2 = diagram.getExistingTask(code2);
        if (task2 == null) {
            return CommandExecutionResult.error("No such task " + code2);
        }
        TaskInstant end1 = new TaskInstant(task1, TaskAttribute.END);
        task2.setStart(end1.getInstantPrecise());
        diagram.addContraint(new GanttConstraint(end1, new TaskInstant(task2, TaskAttribute.START)));
        return CommandExecutionResult.ok();
    }
}

