/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.AlignmentParam;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.Hideable;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.LineParam;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.Pragma;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.command.Position;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.EntityPort;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkArrow;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkMiddleDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;
import net.sourceforge.plantuml.cucadiagram.NoteLinkStrategy;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizVersion;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockArrow;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.graphic.USymbolFolder;
import net.sourceforge.plantuml.graphic.VerticalAlignment;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.posimo.BezierUtils;
import net.sourceforge.plantuml.posimo.DotPath;
import net.sourceforge.plantuml.posimo.Moveable;
import net.sourceforge.plantuml.posimo.Positionable;
import net.sourceforge.plantuml.posimo.PositionableUtils;
import net.sourceforge.plantuml.skin.VisibilityModifier;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.svek.ArithmeticStrategySum;
import net.sourceforge.plantuml.svek.Bibliotekon;
import net.sourceforge.plantuml.svek.Cluster;
import net.sourceforge.plantuml.svek.ColorSequence;
import net.sourceforge.plantuml.svek.DotMode;
import net.sourceforge.plantuml.svek.DotStringFactory;
import net.sourceforge.plantuml.svek.MinFinder;
import net.sourceforge.plantuml.svek.Node;
import net.sourceforge.plantuml.svek.Oscillator;
import net.sourceforge.plantuml.svek.PointAndAngle;
import net.sourceforge.plantuml.svek.PointListIterator;
import net.sourceforge.plantuml.svek.Side;
import net.sourceforge.plantuml.svek.SvekUtils;
import net.sourceforge.plantuml.svek.SvgResult;
import net.sourceforge.plantuml.svek.extremity.Extremity;
import net.sourceforge.plantuml.svek.extremity.ExtremityFactory;
import net.sourceforge.plantuml.svek.extremity.ExtremityFactoryExtends;
import net.sourceforge.plantuml.svek.extremity.ExtremityOther;
import net.sourceforge.plantuml.svek.image.EntityImageNoteLink;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorNone;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class Line
implements Moveable,
Hideable {
    private static final Dimension2DDouble CONSTRAINT_SPOT = new Dimension2DDouble(10.0, 10.0);
    private final Cluster ltail;
    private final Cluster lhead;
    private final Link link;
    private final EntityPort startUid;
    private final EntityPort endUid;
    private final TextBlock startTailText;
    private final TextBlock endHeadText;
    private final TextBlock labelText;
    private boolean divideLabelWidthByTwo = false;
    private final int lineColor;
    private final int noteLabelColor;
    private final int startTailColor;
    private final int endHeadColor;
    private final StringBounder stringBounder;
    private final Bibliotekon bibliotekon;
    private DotPath dotPath;
    private Positionable startTailLabelXY;
    private Positionable endHeadLabelXY;
    private Positionable labelXY;
    private UDrawable extremity2;
    private UDrawable extremity1;
    private double dx;
    private double dy;
    private boolean opale;
    private Cluster projectionCluster;
    private final Pragma pragma;
    private final HColor backgroundColor;
    private final boolean useRankSame;
    private final UStroke defaultThickness;
    private HColor arrowLollipopColor;
    private final ISkinParam skinParam;

    public String toString() {
        return super.toString() + " color=" + this.lineColor;
    }

    private Cluster getCluster2(Bibliotekon bibliotekon, IEntity entityMutable) {
        for (Cluster cl : bibliotekon.allCluster()) {
            if (!cl.getGroups().contains(entityMutable)) continue;
            return cl;
        }
        throw new IllegalArgumentException();
    }

    public Line(Link link, ColorSequence colorSequence, ISkinParam skinParam, StringBounder stringBounder, FontConfiguration labelFont, Bibliotekon bibliotekon, Pragma pragma) {
        EntityImageNoteLink noteOnly;
        TextBlock labelOnly;
        if (link == null) {
            throw new IllegalArgumentException();
        }
        this.skinParam = skinParam;
        this.useRankSame = skinParam.useRankSame();
        this.startUid = link.getEntityPort1(bibliotekon);
        this.endUid = link.getEntityPort2(bibliotekon);
        Cluster ltail = null;
        if (this.startUid.startsWith("za")) {
            ltail = this.getCluster2(bibliotekon, link.getEntity1());
        }
        Cluster lhead = null;
        if (this.endUid.startsWith("za")) {
            lhead = this.getCluster2(bibliotekon, link.getEntity2());
        }
        if (link.getColors() != null) {
            skinParam = link.getColors().mute(skinParam);
            labelFont = labelFont.mute(link.getColors());
        }
        this.backgroundColor = skinParam.getBackgroundColor(false);
        this.defaultThickness = skinParam.getThickness(LineParam.arrow, null);
        this.arrowLollipopColor = skinParam.getHtmlColor(ColorParam.arrowLollipop, null, false);
        if (this.arrowLollipopColor == null) {
            this.arrowLollipopColor = HColorUtils.WHITE;
        }
        this.pragma = pragma;
        this.bibliotekon = bibliotekon;
        this.stringBounder = stringBounder;
        this.link = link;
        this.ltail = ltail;
        this.lhead = lhead;
        this.lineColor = colorSequence.getValue();
        this.noteLabelColor = colorSequence.getValue();
        this.startTailColor = colorSequence.getValue();
        this.endHeadColor = colorSequence.getValue();
        if (Display.isNull(link.getLabel())) {
            if (this.getLinkArrow() == LinkArrow.NONE) {
                labelOnly = null;
            } else {
                TextBlockArrow right = new TextBlockArrow(Direction.RIGHT, labelFont);
                TextBlockArrow left = new TextBlockArrow(Direction.LEFT, labelFont);
                TextBlockArrow up = new TextBlockArrow(Direction.UP, labelFont);
                TextBlockArrow down = new TextBlockArrow(Direction.DOWN, labelFont);
                labelOnly = new DirectionalTextBlock(right, left, up, down);
            }
        } else {
            TextBlock label = this.getLineLabel(link, skinParam, labelFont);
            if (this.getLinkArrow() == LinkArrow.NONE) {
                labelOnly = label;
            } else {
                TextBlock right = new TextBlockArrow(Direction.RIGHT, labelFont);
                right = TextBlockUtils.mergeLR(label, right, VerticalAlignment.CENTER);
                TextBlock left = new TextBlockArrow(Direction.LEFT, labelFont);
                left = TextBlockUtils.mergeLR(left, label, VerticalAlignment.CENTER);
                TextBlock up = new TextBlockArrow(Direction.UP, labelFont);
                up = TextBlockUtils.mergeTB(up, label, HorizontalAlignment.CENTER);
                TextBlock down = new TextBlockArrow(Direction.DOWN, labelFont);
                down = TextBlockUtils.mergeTB(label, down, HorizontalAlignment.CENTER);
                labelOnly = new DirectionalTextBlock(right, left, up, down);
            }
        }
        if (link.getNote() == null) {
            noteOnly = null;
        } else {
            noteOnly = new EntityImageNoteLink(link.getNote(), link.getNoteColors(), skinParam, link.getStyleBuilder());
            if (link.getNoteLinkStrategy() == NoteLinkStrategy.HALF_NOT_PRINTED || link.getNoteLinkStrategy() == NoteLinkStrategy.HALF_PRINTED_FULL) {
                this.divideLabelWidthByTwo = true;
            }
        }
        this.labelText = labelOnly != null && noteOnly != null ? (link.getNotePosition() == Position.LEFT ? TextBlockUtils.mergeLR(noteOnly, labelOnly, VerticalAlignment.CENTER) : (link.getNotePosition() == Position.RIGHT ? TextBlockUtils.mergeLR(labelOnly, noteOnly, VerticalAlignment.CENTER) : (link.getNotePosition() == Position.TOP ? TextBlockUtils.mergeTB(noteOnly, labelOnly, HorizontalAlignment.CENTER) : TextBlockUtils.mergeTB(labelOnly, noteOnly, HorizontalAlignment.CENTER)))) : (labelOnly != null ? labelOnly : (noteOnly != null ? noteOnly : null));
        this.startTailText = link.getQualifier1() == null ? null : Display.getWithNewlines(link.getQualifier1()).create(labelFont, HorizontalAlignment.CENTER, skinParam);
        this.endHeadText = link.getQualifier2() == null ? null : Display.getWithNewlines(link.getQualifier2()).create(labelFont, HorizontalAlignment.CENTER, skinParam);
    }

    private TextBlock getLineLabel(Link link, ISkinParam skinParam, FontConfiguration labelFont) {
        double marginLabel = this.startUid.equalsId(this.endUid) ? 6.0 : 1.0;
        HorizontalAlignment alignment = this.getMessageTextAlignment(link.getUmlDiagramType(), skinParam);
        TextBlock label = link.getLabel().create9(labelFont, alignment, skinParam, skinParam.maxMessageSize());
        VisibilityModifier visibilityModifier = link.getVisibilityModifier();
        if (visibilityModifier != null) {
            Rose rose = new Rose();
            HColor fore = rose.getHtmlColor(skinParam, visibilityModifier.getForeground());
            TextBlock visibility = visibilityModifier.getUBlock(skinParam.classAttributeIconSize(), fore, null, false);
            visibility = TextBlockUtils.withMargin(visibility, 0.0, 1.0, 2.0, 0.0);
            label = TextBlockUtils.mergeLR(visibility, label, VerticalAlignment.CENTER);
        }
        label = TextBlockUtils.withMargin(label, marginLabel, marginLabel);
        return label;
    }

    private HorizontalAlignment getMessageTextAlignment(UmlDiagramType umlDiagramType, ISkinParam skinParam) {
        if (umlDiagramType == UmlDiagramType.STATE) {
            return skinParam.getHorizontalAlignment(AlignmentParam.stateMessageAlignment, null, false);
        }
        return skinParam.getDefaultTextAlignment(HorizontalAlignment.CENTER);
    }

    public boolean hasNoteLabelText() {
        return this.labelText != null;
    }

    private LinkArrow getLinkArrow() {
        return this.link.getLinkArrow();
    }

    public void appendLine(GraphvizVersion graphvizVersion, StringBuilder sb, DotMode dotMode) {
        sb.append(this.startUid.getFullString());
        sb.append("->");
        sb.append(this.endUid.getFullString());
        sb.append("[");
        LinkType linkType = this.link.getTypePatchCluster();
        String decoration = linkType.getSpecificDecorationSvek();
        if (decoration.length() > 0 && !decoration.endsWith(",")) {
            decoration = decoration + ",";
        }
        sb.append(decoration);
        int length = this.link.getLength();
        if (graphvizVersion.ignoreHorizontalLinks() && length == 1) {
            length = 2;
        }
        if (this.useRankSame) {
            if (this.pragma.horizontalLineBetweenDifferentPackageAllowed() || this.link.isInvis() || length != 1) {
                sb.append("minlen=" + (length - 1));
                sb.append(",");
            }
        } else {
            sb.append("minlen=" + (length - 1));
            sb.append(",");
        }
        sb.append("color=\"" + DotStringFactory.sharp000000(this.lineColor) + "\"");
        if (this.labelText != null || this.link.getLinkConstraint() != null) {
            sb.append(",");
            if (graphvizVersion.useXLabelInsteadOfLabel() || dotMode == DotMode.NO_LEFT_RIGHT_AND_XLABEL) {
                sb.append("xlabel=<");
            } else {
                sb.append("label=<");
            }
            Dimension2DDouble dimNote = this.labelText == null ? CONSTRAINT_SPOT : this.labelText.calculateDimension(this.stringBounder);
            Line.appendTable(sb, this.eventuallyDivideByTwo(dimNote), this.noteLabelColor, graphvizVersion);
            sb.append(">");
        }
        if (this.startTailText != null) {
            sb.append(",");
            sb.append("taillabel=<");
            Line.appendTable(sb, this.startTailText.calculateDimension(this.stringBounder), this.startTailColor, graphvizVersion);
            sb.append(">");
        }
        if (this.endHeadText != null) {
            sb.append(",");
            sb.append("headlabel=<");
            Line.appendTable(sb, this.endHeadText.calculateDimension(this.stringBounder), this.endHeadColor, graphvizVersion);
            sb.append(">");
        }
        if (this.link.isInvis()) {
            sb.append(",");
            sb.append("style=invis");
        }
        if (!this.link.isConstraint() || this.link.hasTwoEntryPointsSameContainer()) {
            sb.append(",constraint=false");
        }
        if (this.link.getSametail() != null) {
            sb.append(",sametail=" + this.link.getSametail());
        }
        sb.append("];");
        SvekUtils.println(sb);
    }

    private Dimension2D eventuallyDivideByTwo(Dimension2D dim) {
        if (this.divideLabelWidthByTwo) {
            return new Dimension2DDouble(dim.getWidth() / 2.0, dim.getHeight());
        }
        return dim;
    }

    public String rankSame() {
        if (!this.pragma.horizontalLineBetweenDifferentPackageAllowed() && this.link.getLength() == 1) {
            return "{rank=same; " + this.getStartUidPrefix() + "; " + this.getEndUidPrefix() + "}";
        }
        return null;
    }

    public static void appendTable(StringBuilder sb, Dimension2D dim, int col, GraphvizVersion graphvizVersion) {
        int w = (int)dim.getWidth();
        int h = (int)dim.getHeight();
        Line.appendTable(sb, w, h, col);
    }

    public static void appendTable(StringBuilder sb, int w, int h, int col) {
        sb.append("<TABLE ");
        sb.append("BGCOLOR=\"" + DotStringFactory.sharp000000(col) + "\" ");
        sb.append("FIXEDSIZE=\"TRUE\" WIDTH=\"" + w + "\" HEIGHT=\"" + h + "\">");
        sb.append("<TR");
        sb.append(">");
        sb.append("<TD");
        sb.append(">");
        sb.append("</TD>");
        sb.append("</TR>");
        sb.append("</TABLE>");
    }

    public final String getStartUidPrefix() {
        return this.startUid.getPrefix();
    }

    public final String getEndUidPrefix() {
        return this.endUid.getPrefix();
    }

    private UDrawable getExtremity(LinkDecor decor, PointListIterator pointListIterator, final Point2D center, double angle, Cluster cluster, Node nodeContact) {
        ExtremityFactory extremityFactory = decor.getExtremityFactory(this.backgroundColor);
        if (cluster != null) {
            if (extremityFactory != null) {
                return extremityFactory.createUDrawable(center, angle, null);
            }
            if (decor == LinkDecor.EXTENDS) {
                return new ExtremityFactoryExtends(this.backgroundColor).createUDrawable(center, angle, null);
            }
            return null;
        }
        if (extremityFactory != null) {
            List points = (List)pointListIterator.next();
            if (points.size() == 0) {
                return extremityFactory.createUDrawable(center, angle, null);
            }
            Point2D p0 = (Point2D)points.get(0);
            Point2D p1 = (Point2D)points.get(1);
            Point2D p2 = (Point2D)points.get(2);
            Side side = null;
            if (nodeContact != null) {
                side = nodeContact.getClusterPosition().getClosestSide(p1);
            }
            return extremityFactory.createUDrawable(p0, p1, p2, side);
        }
        if (decor == LinkDecor.NONE) {
            UPolygon sh = new UPolygon((List)pointListIterator.cloneMe().next());
            final Point2D contact = sh.checkMiddleContactForSpecificTriangle(center);
            if (contact != null) {
                return new UDrawable(){

                    @Override
                    public void drawU(UGraphic ug) {
                        ULine line = new ULine(contact.getX() - center.getX(), contact.getY() - center.getY());
                        ug = ug.apply(new UTranslate(center));
                        ug.draw(line);
                    }
                };
            }
        } else if (decor != LinkDecor.NONE) {
            UPolygon sh = new UPolygon((List)pointListIterator.next());
            return new ExtremityOther(sh);
        }
        return null;
    }

    public void solveLine(SvgResult fullSvg, MinFinder corner1) {
        Point2D.Double pos;
        if (this.link.isInvis()) {
            return;
        }
        int idx = fullSvg.getIndexFromColor(this.lineColor);
        if (idx == -1) {
            return;
        }
        if ((idx = fullSvg.indexOf("d=\"", idx)) == -1) {
            throw new IllegalStateException();
        }
        int end = fullSvg.indexOf("\"", idx + 3);
        SvgResult path = fullSvg.substring(idx + 3, end);
        if (!DotPath.isPathConsistent(path.getSvg())) {
            return;
        }
        this.dotPath = new DotPath(path);
        if (this.projectionCluster != null) {
            this.projectionCluster.manageEntryExitPoint(this.stringBounder);
        }
        this.dotPath = this.dotPath.simulateCompound(this.lhead, this.ltail);
        SvgResult lineSvg = fullSvg.substring(end);
        PointListIterator pointListIterator = lineSvg.getPointsWithThisColor(this.lineColor);
        LinkType linkType = this.link.getType();
        this.extremity1 = this.getExtremity(linkType.getDecor2(), pointListIterator, this.dotPath.getStartPoint(), this.dotPath.getStartAngle() + Math.PI, this.ltail, this.bibliotekon.getNode(this.link.getEntity1()));
        this.extremity2 = this.getExtremity(linkType.getDecor1(), pointListIterator, this.dotPath.getEndPoint(), this.dotPath.getEndAngle(), this.lhead, this.bibliotekon.getNode(this.link.getEntity2()));
        if (this.link.getEntity1().getLeafType() == LeafType.LOLLIPOP_HALF) {
            this.bibliotekon.getNode(this.link.getEntity1()).addImpact(this.dotPath.getStartAngle() + Math.PI);
        }
        if (this.link.getEntity2().getLeafType() == LeafType.LOLLIPOP_HALF) {
            this.bibliotekon.getNode(this.link.getEntity2()).addImpact(this.dotPath.getEndAngle());
        }
        if (this.extremity1 instanceof Extremity && this.extremity2 instanceof Extremity) {
            Point2D p1 = ((Extremity)this.extremity1).somePoint();
            Point2D p2 = ((Extremity)this.extremity2).somePoint();
            if (p1 != null && p2 != null) {
                double dist1start = p1.distance(this.dotPath.getStartPoint());
                double dist1end = p1.distance(this.dotPath.getEndPoint());
                double dist2start = p2.distance(this.dotPath.getStartPoint());
                double dist2end = p2.distance(this.dotPath.getEndPoint());
                if (dist1start > dist1end && dist2end > dist2start) {
                    pointListIterator = lineSvg.getPointsWithThisColor(this.lineColor);
                    this.extremity2 = this.getExtremity(linkType.getDecor1(), pointListIterator, this.dotPath.getEndPoint(), this.dotPath.getEndAngle(), this.lhead, this.bibliotekon.getNode(this.link.getEntity2()));
                    this.extremity1 = this.getExtremity(linkType.getDecor2(), pointListIterator, this.dotPath.getStartPoint(), this.dotPath.getStartAngle() + Math.PI, this.ltail, this.bibliotekon.getNode(this.link.getEntity1()));
                }
            }
        }
        if ((this.labelText != null || this.link.getLinkConstraint() != null) && (pos = this.getXY(fullSvg, this.noteLabelColor)) != null) {
            corner1.manage(pos);
            Positionable positionable = this.labelXY = this.labelText == null ? TextBlockUtils.asPositionable(CONSTRAINT_SPOT, this.stringBounder, (Point2D)pos) : TextBlockUtils.asPositionable(this.labelText, this.stringBounder, (Point2D)pos);
        }
        if (this.startTailText != null && (pos = this.getXY(fullSvg, this.startTailColor)) != null) {
            corner1.manage(pos);
            this.startTailLabelXY = TextBlockUtils.asPositionable(this.startTailText, this.stringBounder, (Point2D)pos);
        }
        if (this.endHeadText != null && (pos = this.getXY(fullSvg, this.endHeadColor)) != null) {
            corner1.manage(pos);
            this.endHeadLabelXY = TextBlockUtils.asPositionable(this.endHeadText, this.stringBounder, (Point2D)pos);
            corner1.manage(((Point2D)pos).getX() - 15.0, ((Point2D)pos).getY());
        }
        if (!this.isOpalisable()) {
            this.setOpale(false);
        }
    }

    private boolean isOpalisable() {
        return this.dotPath.getBeziers().size() <= 1;
    }

    private Point2D.Double getXY(SvgResult svgResult, int color) {
        int idx = svgResult.getIndexFromColor(color);
        if (idx == -1) {
            return null;
        }
        return SvekUtils.getMinXY(svgResult.substring(idx).extractList("points=\""));
    }

    public void drawU(UGraphic ug, HColor color, Set<String> ids) {
        Cluster endCluster;
        Cluster cl;
        if (this.opale) {
            return;
        }
        ug.draw(this.link.commentForSvg());
        double x = 0.0;
        double y = 0.0;
        Url url = this.link.getUrl();
        if (url != null) {
            ug.startUrl(url);
        }
        if (this.link.isAutoLinkOfAGroup() && (cl = this.bibliotekon.getCluster((IGroup)this.link.getEntity1())) != null) {
            x += cl.getWidth();
            x -= this.dotPath.getStartPoint().getX() - cl.getMinX();
        }
        x += this.dx;
        y += this.dy;
        if (this.link.isInvis()) {
            return;
        }
        if (this.link.getColors() != null) {
            HColor newColor = this.link.getColors().getColor(ColorType.ARROW, ColorType.LINE);
            if (newColor != null) {
                color = newColor;
            }
        } else if (this.link.getSpecificColor() != null) {
            color = this.link.getSpecificColor();
        }
        ug = ug.apply(new HColorNone().bg()).apply(color);
        LinkType linkType = this.link.getType();
        UStroke stroke = linkType.getStroke3(this.defaultThickness);
        if (this.link.getColors() != null && this.link.getColors().getSpecificLineStroke() != null) {
            stroke = this.link.getColors().getSpecificLineStroke();
        }
        ug = ug.apply(stroke);
        if (this.dotPath == null) {
            Log.info("DotPath is null for " + this);
            return;
        }
        DotPath todraw = this.dotPath;
        if (this.link.getEntity2().isGroup() && this.link.getEntity2().getUSymbol() instanceof USymbolFolder && (endCluster = this.bibliotekon.getCluster((IGroup)this.link.getEntity2())) != null) {
            double deltaFolderH = endCluster.checkFolderPosition(this.dotPath.getEndPoint(), ug.getStringBounder());
            todraw = new DotPath(this.dotPath);
            todraw.moveEndPoint(0.0, deltaFolderH);
        }
        if (this.extremity1 instanceof Extremity && this.extremity2 instanceof Extremity) {
            Point2D p2;
            Point2D p1 = ((Extremity)this.extremity1).isTooSmallSoGiveThePointCloserToThisOne(todraw.getStartPoint());
            if (p1 != null) {
                todraw.forceStartPoint(p1.getX(), p1.getY());
            }
            if ((p2 = ((Extremity)this.extremity2).isTooSmallSoGiveThePointCloserToThisOne(todraw.getEndPoint())) != null) {
                todraw.forceEndPoint(p2.getX(), p2.getY());
            }
        }
        String comment = this.link.idCommentForSvg();
        String tmp = this.uniq(ids, comment);
        todraw.setComment(tmp);
        this.drawRainbow(ug.apply(new UTranslate(x, y)), color, todraw, this.link.getSupplementaryColors(), stroke);
        ug = ug.apply(new UStroke()).apply(color);
        if (this.labelText != null && this.labelXY != null && this.link.getNoteLinkStrategy() != NoteLinkStrategy.HALF_NOT_PRINTED) {
            this.labelText.drawU(ug.apply(new UTranslate(x + this.labelXY.getPosition().getX(), y + this.labelXY.getPosition().getY())));
        }
        if (this.startTailText != null && this.startTailLabelXY != null && this.startTailLabelXY.getPosition() != null) {
            this.startTailText.drawU(ug.apply(new UTranslate(x + this.startTailLabelXY.getPosition().getX(), y + this.startTailLabelXY.getPosition().getY())));
        }
        if (this.endHeadText != null && this.endHeadLabelXY != null && this.endHeadLabelXY.getPosition() != null) {
            this.endHeadText.drawU(ug.apply(new UTranslate(x + this.endHeadLabelXY.getPosition().getX(), y + this.endHeadLabelXY.getPosition().getY())));
        }
        if (linkType.getMiddleDecor() != LinkMiddleDecor.NONE) {
            PointAndAngle middle = this.dotPath.getMiddle();
            double angleRad = middle.getAngle();
            double angleDeg = -angleRad * 180.0 / Math.PI;
            UDrawable mi = linkType.getMiddleDecor().getMiddleFactory(this.arrowLollipopColor).createUDrawable(angleDeg - 45.0);
            mi.drawU(ug.apply(new UTranslate(x + middle.getX(), y + middle.getY())));
        }
        if (url != null) {
            ug.closeAction();
        }
        if (this.link.getLinkConstraint() != null) {
            double xConstraint = x + this.labelXY.getPosition().getX();
            double yConstraint = y + this.labelXY.getPosition().getY();
            List<Point2D> square = this.getSquare(xConstraint, yConstraint);
            Set<Point2D> bez = this.dotPath.sample();
            Point2D minPt = null;
            double minDist = Double.MAX_VALUE;
            for (Point2D pt : square) {
                for (Point2D pt2 : bez) {
                    double distance = pt2.distance(pt);
                    if (minPt != null && !(distance < minDist)) continue;
                    minPt = pt;
                    minDist = distance;
                }
            }
            this.link.getLinkConstraint().setPosition(this.link, minPt);
            this.link.getLinkConstraint().drawMe(ug, this.skinParam);
        }
    }

    private List<Point2D> getSquare(double x, double y) {
        ArrayList<Point2D> result = new ArrayList<Point2D>();
        result.add(new Point2D.Double(x, y));
        result.add(new Point2D.Double(x + 5.0, y));
        result.add(new Point2D.Double(x + 10.0, y));
        result.add(new Point2D.Double(x, y + 5.0));
        result.add(new Point2D.Double(x + 10.0, y + 5.0));
        result.add(new Point2D.Double(x, y + 10.0));
        result.add(new Point2D.Double(x + 5.0, y + 10.0));
        result.add(new Point2D.Double(x + 10.0, y + 10.0));
        return result;
    }

    private String uniq(Set<String> ids, String comment) {
        boolean changed = ids.add(comment);
        if (changed) {
            return comment;
        }
        int i = 1;
        String candidate;
        while (!(changed = ids.add(candidate = comment + "-" + i))) {
            ++i;
        }
        return candidate;
    }

    private void drawRainbow(UGraphic ug, HColor color, DotPath todraw, List<Colors> supplementaryColors, UStroke stroke) {
        UGraphic ug2;
        ug.draw(todraw);
        LinkType linkType = this.link.getType();
        if (this.extremity2 != null) {
            ug2 = ug.apply(color).apply(stroke.onlyThickness());
            ug2 = linkType.getDecor1().isFill() ? ug2.apply(color.bg()) : ug2.apply(new HColorNone().bg());
            this.extremity2.drawU(ug2);
        }
        if (this.extremity1 != null) {
            ug2 = ug.apply(color).apply(stroke.onlyThickness());
            ug2 = linkType.getDecor2().isFill() ? ug2.apply(color.bg()) : ug2.apply(new HColorNone().bg());
            this.extremity1.drawU(ug2);
        }
        int i = 0;
        for (Colors colors : supplementaryColors) {
            ug.apply(new UTranslate(2 * (i + 1), 2 * (i + 1))).apply(colors.getColor(ColorType.LINE)).draw(todraw);
            ++i;
        }
    }

    public boolean isInverted() {
        return this.link.isInverted();
    }

    private double getDecorDzeta() {
        LinkType linkType = this.link.getType();
        int size1 = linkType.getDecor1().getMargin();
        int size2 = linkType.getDecor2().getMargin();
        return size1 + size2;
    }

    public double getHorizontalDzeta(StringBounder stringBounder) {
        if (this.startUid.equalsId(this.endUid)) {
            return this.getDecorDzeta();
        }
        if (!this.isHorizontal()) {
            return 0.0;
        }
        ArithmeticStrategySum strategy = new ArithmeticStrategySum();
        if (this.labelText != null) {
            strategy.eat(this.labelText.calculateDimension(stringBounder).getWidth());
        }
        if (this.startTailText != null) {
            strategy.eat(this.startTailText.calculateDimension(stringBounder).getWidth());
        }
        if (this.endHeadText != null) {
            strategy.eat(this.endHeadText.calculateDimension(stringBounder).getWidth());
        }
        return strategy.getResult() + this.getDecorDzeta();
    }

    private boolean isHorizontal() {
        return this.link.getLength() == 1;
    }

    public double getVerticalDzeta(StringBounder stringBounder) {
        if (this.startUid.equalsId(this.endUid)) {
            return this.getDecorDzeta();
        }
        if (this.isHorizontal()) {
            return 0.0;
        }
        ArithmeticStrategySum strategy = new ArithmeticStrategySum();
        if (this.labelText != null) {
            strategy.eat(this.labelText.calculateDimension(stringBounder).getHeight());
        }
        if (this.startTailText != null) {
            strategy.eat(this.startTailText.calculateDimension(stringBounder).getHeight());
        }
        if (this.endHeadText != null) {
            strategy.eat(this.endHeadText.calculateDimension(stringBounder).getHeight());
        }
        return strategy.getResult() + this.getDecorDzeta();
    }

    public void manageCollision(Collection<Node> allNodes) {
        for (Node sh : allNodes) {
            Positionable cl = PositionableUtils.addMargin(sh, 8.0, 8.0);
            if (this.startTailText != null && this.startTailLabelXY != null && PositionableUtils.intersect(cl, this.startTailLabelXY)) {
                this.startTailLabelXY = PositionableUtils.moveAwayFrom(cl, this.startTailLabelXY);
            }
            if (this.endHeadText == null || this.endHeadLabelXY == null || !PositionableUtils.intersect(cl, this.endHeadLabelXY)) continue;
            this.endHeadLabelXY = PositionableUtils.moveAwayFrom(cl, this.endHeadLabelXY);
        }
    }

    private void avoid(Point2D.Double move, Positionable pos, Node sh) {
        Oscillator oscillator = new Oscillator();
        Point2D.Double orig = new Point2D.Double(move.x, move.y);
        while (this.cut(pos, sh)) {
            Point2D.Double m = oscillator.nextPosition();
            move.setLocation(orig.x + m.x, orig.y + m.y);
        }
    }

    private boolean cut(Positionable pos, Node sh) {
        return BezierUtils.intersect(pos, sh) || this.tooClose(pos);
    }

    private boolean tooClose(Positionable pos) {
        Dimension2D dim;
        double dist = this.dotPath.getMinDist(BezierUtils.getCenter(pos));
        return dist < (dim = pos.getSize()).getWidth() / 2.0 + 2.0 || dist < dim.getHeight() / 2.0 + 2.0;
    }

    @Override
    public void moveSvek(double deltaX, double deltaY) {
        this.dx += deltaX;
        this.dy += deltaY;
    }

    public final DotPath getDotPath() {
        DotPath result = new DotPath(this.dotPath);
        result.moveSvek(this.dx, this.dy);
        return result;
    }

    public int getLength() {
        return this.link.getLength();
    }

    public void setOpale(boolean opale) {
        this.link.setOpale(opale);
        this.opale = opale;
    }

    public boolean isOpale() {
        return this.opale;
    }

    public boolean isHorizontalSolitary() {
        return this.link.isHorizontalSolitary();
    }

    public boolean isLinkFromOrTo(IEntity group) {
        return this.link.getEntity1() == group || this.link.getEntity2() == group;
    }

    public boolean hasEntryPoint() {
        return this.link.hasEntryPoint();
    }

    public void setProjectionCluster(Cluster cluster) {
        this.projectionCluster = cluster;
    }

    @Override
    public boolean isHidden() {
        return this.link.isHidden();
    }

    public boolean sameConnections(Line other) {
        return this.link.sameConnections(other.link);
    }

    private boolean isAutolink() {
        return this.link.getEntity1() == this.link.getEntity2();
    }

    public Point2D getMyPoint(IEntity entity) {
        if (this.link.getEntity1() == entity) {
            return this.moveDelta(this.dotPath.getStartPoint());
        }
        if (this.link.getEntity2() == entity) {
            return this.moveDelta(this.dotPath.getEndPoint());
        }
        throw new IllegalArgumentException();
    }

    private Point2D moveDelta(Point2D pt) {
        return new Point2D.Double(pt.getX() + this.dx, pt.getY() + this.dy);
    }

    public boolean isLink(Link link) {
        return this.link == link;
    }

    public Point2D getStartContactPoint() {
        Point2D start = this.dotPath.getStartPoint();
        if (start == null) {
            return null;
        }
        return new Point2D.Double(this.dx + start.getX(), this.dy + start.getY());
    }

    public Point2D getEndContactPoint() {
        Point2D end = this.dotPath.getEndPoint();
        if (end == null) {
            return null;
        }
        return new Point2D.Double(this.dx + end.getX(), this.dy + end.getY());
    }

    public IEntity getOther(IEntity entity) {
        if (this.link.contains(entity)) {
            return this.link.getOther(entity);
        }
        return null;
    }

    class DirectionalTextBlock
    extends AbstractTextBlock
    implements TextBlock {
        private final TextBlock right;
        private final TextBlock left;
        private final TextBlock up;
        private final TextBlock down;

        DirectionalTextBlock(TextBlock right, TextBlock left, TextBlock up, TextBlock down) {
            this.right = right;
            this.left = left;
            this.up = up;
            this.down = down;
        }

        @Override
        public void drawU(UGraphic ug) {
            Direction dir = this.getDirection();
            if (Line.this.getLinkArrow() == LinkArrow.BACKWARD) {
                dir = dir.getInv();
            }
            switch (dir) {
                case RIGHT: {
                    this.right.drawU(ug);
                    break;
                }
                case LEFT: {
                    this.left.drawU(ug);
                    break;
                }
                case UP: {
                    this.up.drawU(ug);
                    break;
                }
                case DOWN: {
                    this.down.drawU(ug);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }

        @Override
        public Dimension2D calculateDimension(StringBounder stringBounder) {
            return this.right.calculateDimension(stringBounder);
        }

        private Direction getDirection() {
            if (Line.this.isAutolink()) {
                double startAngle = Line.this.dotPath.getStartAngle();
                return Direction.LEFT;
            }
            Point2D start = Line.this.dotPath.getStartPoint();
            Point2D end = Line.this.dotPath.getEndPoint();
            double ang = Math.atan2(end.getX() - start.getX(), end.getY() - start.getY());
            if (ang > -0.7853981633974483 && ang < 0.7853981633974483) {
                return Direction.DOWN;
            }
            if (ang > 2.356194490192345 || ang < -2.356194490192345) {
                return Direction.UP;
            }
            return end.getX() > start.getX() ? Direction.RIGHT : Direction.LEFT;
        }
    }
}

