/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.command.Position;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.timingdiagram.Player;
import net.sourceforge.plantuml.timingdiagram.TimeTick;
import net.sourceforge.plantuml.timingdiagram.TimingRuler;
import net.sourceforge.plantuml.timingdiagram.graphic.IntricatedPoint;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class PlayerBinary
extends Player {
    private final SortedMap<TimeTick, Boolean> values = new TreeMap<TimeTick, Boolean>();
    private Boolean initialState;
    private final double ymargin = 8.0;

    public PlayerBinary(String code, ISkinParam skinParam, TimingRuler ruler, boolean compact) {
        super(code, skinParam, ruler, compact);
        this.suggestedHeight = 30;
    }

    @Override
    public double getFullHeight(StringBounder stringBounder) {
        return this.suggestedHeight;
    }

    public void drawFrameTitle(UGraphic ug) {
    }

    private SymbolContext getContext() {
        return new SymbolContext(HColorUtils.COL_D7E0F2, HColorUtils.COL_038048).withStroke(new UStroke(1.5));
    }

    @Override
    public IntricatedPoint getTimeProjection(StringBounder stringBounder, TimeTick tick) {
        double x = this.ruler.getPosInPixel(tick);
        return new IntricatedPoint(new Point2D.Double(x, this.getYpos(false)), new Point2D.Double(x, this.getYpos(true)));
    }

    @Override
    public void addNote(TimeTick now, Display note, Position position) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void defineState(String stateCode, String label) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setState(TimeTick now, String comment, Colors color, String ... states) {
        boolean state = this.getState(states[0]);
        if (now == null) {
            this.initialState = state;
        } else {
            this.values.put(now, state);
        }
    }

    private boolean getState(String value) {
        return "1".equals(value) || "high".equalsIgnoreCase(value);
    }

    @Override
    public void createConstraint(TimeTick tick1, TimeTick tick2, String message) {
        throw new UnsupportedOperationException();
    }

    private double getYpos(boolean state) {
        return state ? 8.0 : this.getFullHeight(null) - 8.0;
    }

    @Override
    public TextBlock getPart1(double fullAvailableWidth, double specialVSpace) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                StringBounder stringBounder = ug.getStringBounder();
                TextBlock title = PlayerBinary.this.getTitle();
                Dimension2D dim = title.calculateDimension(stringBounder);
                double y = (PlayerBinary.this.getFullHeight(stringBounder) - dim.getHeight()) / 2.0;
                title.drawU(ug.apply(UTranslate.dy(y)));
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                Dimension2D dim = PlayerBinary.this.getTitle().calculateDimension(stringBounder);
                return Dimension2DDouble.delta(dim, 5.0, 0.0);
            }
        };
    }

    @Override
    public UDrawable getPart2() {
        return new UDrawable(){

            @Override
            public void drawU(UGraphic ug) {
                ug = PlayerBinary.this.getContext().apply(ug);
                double lastx = 0.0;
                boolean lastValue = PlayerBinary.this.initialState == null ? false : PlayerBinary.this.initialState;
                for (Map.Entry ent : PlayerBinary.this.values.entrySet()) {
                    double x = PlayerBinary.this.ruler.getPosInPixel((TimeTick)ent.getKey());
                    ug.apply(new UTranslate(lastx, PlayerBinary.this.getYpos(lastValue))).draw(ULine.hline(x - lastx));
                    if (lastValue != (Boolean)ent.getValue()) {
                        ug.apply(new UTranslate(x, 8.0)).draw(ULine.vline(PlayerBinary.this.getFullHeight(null) - 16.0));
                    }
                    lastx = x;
                    lastValue = (Boolean)ent.getValue();
                }
                ug.apply(new UTranslate(lastx, PlayerBinary.this.getYpos(lastValue))).draw(ULine.hline(PlayerBinary.this.ruler.getWidth() - lastx));
            }
        };
    }
}

