/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram;

import java.awt.geom.Dimension2D;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.timingdiagram.TimeTick;
import net.sourceforge.plantuml.timingdiagram.TimingFormat;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorSet;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class TimingRuler {
    private final SortedSet<TimeTick> times = new TreeSet<TimeTick>();
    private final ISkinParam skinParam;
    private long tickIntervalInPixels = 50L;
    private long tickUnitary;
    private TimingFormat format = TimingFormat.DECIMAL;
    private long highestCommonFactorInternal = -1L;

    static UGraphic applyForVLines(UGraphic ug) {
        UStroke stroke = new UStroke(3.0, 5.0, 0.5);
        HColor color = HColorSet.instance().getColorIfValid("#AAA");
        return ug.apply(stroke).apply(color);
    }

    public void ensureNotEmpty() {
        if (this.times.size() == 0) {
            this.times.add(new TimeTick(BigDecimal.ZERO, TimingFormat.DECIMAL));
        }
    }

    public TimingRuler(ISkinParam skinParam) {
        this.skinParam = skinParam;
    }

    public void scaleInPixels(long tick, long pixel) {
        this.tickIntervalInPixels = pixel;
        this.tickUnitary = tick;
    }

    private long tickUnitary() {
        if (this.tickUnitary == 0L) {
            return this.highestCommonFactor();
        }
        return this.tickUnitary;
    }

    private long highestCommonFactor() {
        if (this.highestCommonFactorInternal == -1L) {
            for (TimeTick time : this.times) {
                long tick = time.getTime().longValue();
                if (tick <= 0L) continue;
                if (this.highestCommonFactorInternal == -1L) {
                    this.highestCommonFactorInternal = time.getTime().longValue();
                    continue;
                }
                this.highestCommonFactorInternal = TimingRuler.computeHighestCommonFactor(this.highestCommonFactorInternal, Math.abs(time.getTime().longValue()));
            }
        }
        return this.highestCommonFactorInternal;
    }

    private int getNbTick(boolean capped) {
        if (this.times.size() == 0) {
            return 1;
        }
        long delta = this.getMax().getTime().longValue() - this.getMin().getTime().longValue();
        return Math.min(1000, (int)(1L + delta / this.tickUnitary()));
    }

    public double getWidth() {
        return (long)this.getNbTick(false) * this.tickIntervalInPixels;
    }

    public final double getPosInPixel(TimeTick when) {
        return this.getPosInPixelInternal(when.getTime().doubleValue());
    }

    private double getPosInPixelInternal(double time) {
        return (time -= this.getMin().getTime().doubleValue()) / (double)this.tickUnitary() * (double)this.tickIntervalInPixels;
    }

    public void addTime(TimeTick time) {
        this.highestCommonFactorInternal = -1L;
        this.times.add(time);
        if (time.getFormat() != TimingFormat.DECIMAL) {
            this.format = time.getFormat();
        }
    }

    private FontConfiguration getFontConfiguration() {
        return new FontConfiguration(this.skinParam, FontParam.TIMING, null);
    }

    private TextBlock getTimeTextBlock(long time) {
        Display display = Display.getWithNewlines(this.format.formatTime(time));
        return display.create(this.getFontConfiguration(), HorizontalAlignment.LEFT, this.skinParam);
    }

    public void drawTimeAxis(UGraphic ug) {
        ug = ug.apply(new UStroke(2.0)).apply(HColorUtils.BLACK);
        double tickHeight = 5.0;
        ULine line = ULine.vline(5.0);
        int nb = this.getNbTick(true);
        for (int i = 0; i <= nb; ++i) {
            ug.apply(UTranslate.dx(this.tickIntervalInPixels * (long)i)).draw(line);
        }
        ug.draw(ULine.hline((long)nb * this.tickIntervalInPixels));
        for (long round : this.roundValues()) {
            TextBlock text = this.getTimeTextBlock(round);
            Dimension2D dim = text.calculateDimension(ug.getStringBounder());
            text.drawU(ug.apply(new UTranslate(this.getPosInPixelInternal(round) - dim.getWidth() / 2.0, 6.0)));
        }
    }

    private Collection<Long> roundValues() {
        TreeSet<Long> result = new TreeSet<Long>();
        if (this.tickUnitary == 0L) {
            for (TimeTick tick : this.times) {
                long round = tick.getTime().longValue();
                result.add(round);
            }
        } else {
            int nb = this.getNbTick(true);
            for (int i = 0; i <= nb; ++i) {
                long round = this.tickUnitary * (long)i;
                result.add(round);
            }
        }
        if ((Long)result.first() < 0L && (Long)result.last() > 0L) {
            result.add(0L);
        }
        return result;
    }

    public void drawVlines(UGraphic ug, double height) {
        ug = TimingRuler.applyForVLines(ug);
        ULine line = ULine.vline(height);
        int nb = this.getNbTick(true);
        for (int i = 0; i <= nb; ++i) {
            ug.apply(UTranslate.dx(this.tickIntervalInPixels * (long)i)).draw(line);
        }
    }

    public double getHeight(StringBounder stringBounder) {
        return this.getTimeTextBlock(0L).calculateDimension(stringBounder).getHeight();
    }

    private TimeTick getMax() {
        return this.times.last();
    }

    private TimeTick getMin() {
        return this.times.first();
    }

    private static long computeHighestCommonFactor(long a, long b) {
        long r = a;
        while (r != 0L) {
            r = a % b;
            a = b;
            b = r;
        }
        return Math.abs(a);
    }
}

