/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.g2d;

import java.awt.BasicStroke;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import net.sourceforge.plantuml.EnsureVisible;
import net.sourceforge.plantuml.ugraphic.UDriver;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.color.ColorMapper;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorGradient;
import net.sourceforge.plantuml.ugraphic.g2d.DriverLineG2d;
import net.sourceforge.plantuml.ugraphic.g2d.DriverRectangleG2d;
import net.sourceforge.plantuml.ugraphic.g2d.DriverShadowedG2d;

public class DriverPolygonG2d
extends DriverShadowedG2d
implements UDriver<Graphics2D> {
    private final double dpiFactor;
    private final EnsureVisible visible;

    public DriverPolygonG2d(double dpiFactor, EnsureVisible visible) {
        this.dpiFactor = dpiFactor;
        this.visible = visible;
    }

    @Override
    public void draw(UShape ushape, double x, double y, ColorMapper mapper, UParam param, Graphics2D g2d) {
        HColor back;
        UPolygon shape = (UPolygon)ushape;
        g2d.setStroke(new BasicStroke((float)param.getStroke().getThickness()));
        GeneralPath path = new GeneralPath();
        boolean first = true;
        for (Point2D point2D : shape.getPoints()) {
            double xp = point2D.getX() + x;
            double yp = point2D.getY() + y;
            this.visible.ensureVisible(xp, yp);
            if (first) {
                path.moveTo((float)xp, (float)yp);
            } else {
                path.lineTo((float)xp, (float)yp);
            }
            first = false;
        }
        if (!first) {
            path.closePath();
        }
        if (shape.getDeltaShadow() != 0.0) {
            this.drawShadow(g2d, path, shape.getDeltaShadow(), this.dpiFactor);
        }
        if ((back = param.getBackcolor()) instanceof HColorGradient) {
            HColorGradient hColorGradient = (HColorGradient)back;
            char policy = hColorGradient.getPolicy();
            GradientPaint paint = policy == '|' ? new GradientPaint((float)x, (float)(y + shape.getHeight()) / 2.0f, mapper.toColor(hColorGradient.getColor1()), (float)(x + shape.getWidth()), (float)(y + shape.getHeight()) / 2.0f, mapper.toColor(hColorGradient.getColor2())) : (policy == '\\' ? new GradientPaint((float)x, (float)(y + shape.getHeight()), mapper.toColor(hColorGradient.getColor1()), (float)(x + shape.getWidth()), (float)y, mapper.toColor(hColorGradient.getColor2())) : (policy == '-' ? new GradientPaint((float)(x + shape.getWidth()) / 2.0f, (float)y, mapper.toColor(hColorGradient.getColor1()), (float)(x + shape.getWidth()) / 2.0f, (float)(y + shape.getHeight()), mapper.toColor(hColorGradient.getColor2())) : new GradientPaint((float)x, (float)y, mapper.toColor(hColorGradient.getColor1()), (float)(x + shape.getWidth()), (float)(y + shape.getHeight()), mapper.toColor(hColorGradient.getColor2()))));
            g2d.setPaint(paint);
            g2d.fill(path);
        } else if (back != null) {
            g2d.setColor(mapper.toColor(back));
            DriverRectangleG2d.managePattern(param, g2d);
            g2d.fill(path);
        }
        if (param.getColor() != null) {
            g2d.setColor(mapper.toColor(param.getColor()));
            DriverLineG2d.manageStroke(param, g2d);
            g2d.draw(path);
        }
    }
}

